package ss2010.riesenalk;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.io.*;

/**
 * Penguin - A robot by Daniel Thorn & Thorsten Heck
 * Based on AntiGravityBot - A robot by Alisdair Owens
 */
public class Penguin extends TeamRobot
{
	/**
	 * Alle Einträge mit Verfasser sind Neuentwicklungen - die Codezeilen ohne Verfasser sind aus dem AntiGravityBot von Alisdair Owens entnommen - die Originalkommentare sind unverändert
	 */
	double disthelp = 10000;		// hilfsvariable - daniel thorn
	Hashtable targets;				//all enemies are stored in the hashtable
	Enemy target;					//our current enemy
	Enemy angreifer;				// Robot der uns aktuell angreift - Daniel Thorn
	Enemy tma;						// Aktueller Angreifer des Teammates - Daniel Thorn
	int direction = 1;				//direction we are heading... 1 = forward, -1 = backwards
	double FirePower;				//the power of the shot we will be using
	double midpointstrength = 0;	//The strength of the gravity point in the middle of the field
	int midpointcount = 0;			//Number of turns since that strength was changed.
	int anzAttacks =0;				// Anzahl der Geschosseinschläge von einem Robot am Stück (soll erkennen ob der bot gezielt angegriffen wird) - Daniel Thorn
	
	public void run() { //Alle Einträge mit Verfasser sind Neuentwicklungen - die Codezeilen ohne Verfasser sind aus dem AntiGravityBot von Alisdair Owens entnommen
		targets = new Hashtable();
		target = new Enemy();
		target.distance = 100000;						//initialise the distance so that we can select a target
		angreifer = new Enemy();						// Initalisierung von Angreifer und TMA - Daniel Thorn
		angreifer.distance = 10000;
		tma = new Enemy();
		tma.distance = 10000;
		setColors(Color.black,Color.black,Color.black);
		//the next two lines mean that the turns of the robot, gun and radar are independant -> Voraussetzung für das Anti Gravity Movement
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		turnRadarRightRadians(2*Math.PI);					//turns the radar right around to get a view of the field
		while(true) {
			antiGravMove();					//Move the bot
			doFirePower();					//select the fire power to use
			doScanner();					//Oscillate the scanner over the bot
			doGun();
			out.println(target.distance);	//move the gun to predict where the enemy will be
			fire(FirePower);
			execute();						//execute all commands
		}
	}
	
	void antiGravMove() { // angelehnt an AntiGravityBot von Alisdair Owens - jedoch offensive ausgestaltung (nicht defensiv/zurückhaltend)- Daniel Thorn
   		double xforce = 0;
	    double yforce = 0;
	    double force;
	    double ang;
	    GravPoint p;
		Enemy en;
    	Enumeration e = targets.elements();
	    // suche aktuelles target aus hashtable - Daniel Thorn
		while (e.hasMoreElements()) {
    	    en = (Enemy)e.nextElement();
			if (en.live && en.name.equals(target.name)) { // immer aktuelles target verfolgen
				// forces werden auf 0 gesetzt damit nur target beachtet wird (ansonsten würden kummulierte summen alle bots berücksichtigen)
				xforce=0;
				yforce=0;
				p = new GravPoint(en.x,en.y, +1000); // gravpoint positiv um anziehende, keine repulsive, wirkung zu bekommen => Aggressivität
		        force = p.power/Math.pow(getRange(getX(),getY(),p.x,p.y),2);
		        //Find the bearing from the point to us
		        ang = normaliseBearing(Math.PI/2 - Math.atan2(getY() - p.y, getX() - p.x)); 
		        //Add the components of this force to the total force in their respective directions
		        xforce += Math.sin(ang) * force;
		        yforce += Math.cos(ang) * force;
			}
	    }
	    
	    /**The following four lines add wall avoidance.  They will only affect us if the bot is close 
	    to the walls due to the force from the walls decreasing at a power 3.**/
		// abweisende power der GravPoints an den Wänden von 5000 auf 2000 gesenkt um stärkeren Fokus auf das Target zu richten
	    xforce += 2000/Math.pow(getRange(getX(), getY(), getBattleFieldWidth(), getY()), 3);
	    xforce -= 2000/Math.pow(getRange(getX(), getY(), 0, getY()), 3);
	    yforce += 2000/Math.pow(getRange(getX(), getY(), getX(), getBattleFieldHeight()), 3);
	    yforce -= 2000/Math.pow(getRange(getX(), getY(), getX(), 0), 3);
	    
	    //Move in the direction of our resolved force. - hier wird auch die Distanz zum Bot übergeben - Daniel Thorn
	    goTo(getX()-xforce,getY()-yforce, target.distance);
	}
	
	void doFirePower(){ // Kalkulation Schussstärke Daniel Thorn
		double a = getBattleFieldWidth();
		double b = getBattleFieldHeight();
		double o = getOthers();
		double c = (a*b)/o; // Schussstärke abhängig von der Anzahl der Robots in der Arena und größe der Arena - Daniel Thorn
		if (c <= 24000 || FirePower >= 3 || target.distance <=20) // bei Tests hat sich gezeigt das bei einem Wert von kleiner 24000 kaum ein Schuss vorbeigeht - Daniel Thorn
		{
			FirePower = 3;
		}	
		else
		{
			FirePower = 600/target.distance;//Schusstärke ist auch abhängig von der Entfernung zum Feind - je größer die Zahl (600) desto aggressiver (angelehnt an Alisdair Ownes)
		}
	}
	/**Move towards an x and y coordinate**/
	void goTo(double x, double y, double currdist) {//entnommen aus AntiGravityBot von Alisdair Owens - Distanz ist hier variabel keine fixen Bewegungsabläufe - Daniel Thorn
	    double dist = currdist+10; // Versuch Feind zu Rammen
		if (dist > 50)
		{
			dist=50; // max. 50 Bewegung in eine Richtung da ansonsten zu großes Risiko im offenen Feld gerammt zu werden oder unter Beschuss zu kommen
		}
	    double angle = Math.toDegrees(absbearing(getX(),getY(),x,y));
	    double r = turnTo(angle);
	    setAhead(dist * r);
	}

	/**keep the scanner turning (from AntiGravityBot - kann nicht geändert werden, da  ansonsten hashtable nicht aktuell ist - Daniel Thorn)**/
	void doScanner() {
		setTurnRadarLeftRadians(2*Math.PI);
	}

	void doGun ()// entnommen aus AntiGravityBot von Alisdair Owens
	{
		long time = getTime()+(int)Math.round(getRange(getX(),getY(),target.x,target.y)/(20-(3*FirePower)));
		Point2D.Double p = target.guessPosition(time);
		double gunOffset = getGunHeadingRadians()- (Math.PI/2 - Math.atan2(p.y - getY(), p.x - getX()));
		setTurnGunLeftRadians(normaliseBearing(gunOffset));
	}
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {//Alle Einträge mit Verfasser sind Neuentwicklungen - die Codezeilen ohne Verfasser sind aus dem AntiGravityBot von Alisdair Owens entnommen
		Enemy en;
		if (targets.containsKey(e.getName())) {
			en = (Enemy)targets.get(e.getName());
		} 
		else {
			en = new Enemy();
			targets.put(e.getName(),en);
		}
		//the next line gets the absolute bearing to the point where the bot is
		double absbearing_rad = (getHeadingRadians()+e.getBearingRadians())%(2*Math.PI);
		//this section sets all the information about our target
		en.name = e.getName();
		double h = normaliseBearing(e.getHeadingRadians() - en.heading);
		h = h/(getTime() - en.ctime);
		en.changehead = h;
		en.x = getX()+Math.sin(absbearing_rad)*e.getDistance(); //works out the x coordinate of where the target is
		en.y = getY()+Math.cos(absbearing_rad)*e.getDistance(); //works out the y coordinate of where the target is
		en.bearing = e.getBearingRadians();
		en.heading = e.getHeadingRadians();
		en.ctime = getTime();				//game time at which this scan was produced
		en.speed = e.getVelocity();
		en.distance = e.getDistance();	
		en.live = true;
		/* Ab hier Daniel Thorn */
		// Teammate wird in hashtable gespeichert für Anti Gravity movement kommt aber nicht als Target in Frage
		if (isTeammate(e.getName()))
		{
			return;
		}
		// check ob der angreifer target wird
		else if (e.getName().equals(angreifer.name) && angreifer.live ==true && (en.distance <= 1.5*target.distance || en.distance <=60))
		{
			target = en;
		}
		// check ob Teammate geholfen wird
		else if (e.getName().equals(tma.name)&& tma.live == true && (en.distance <= 1.5*target.distance || en.distance <=60))
		{
			target = en;
		}
		else if ((en.distance < target.distance)||(target.live == false)) {
			target = en;
		}
		else
		{
			return;
		}
	}

	public void onHitByBullet(HitByBulletEvent e) // Daniel Thorn
	{
		if (isTeammate(e.getName()))
		{
			try 
			{
				sendMessage(e.getName(),"FriendlyFire");
			}
			catch(IOException ex)
			{
				out.println("Fehler beim Senden von Friendly Fire!"+getName());
			}
		}
		else if (e.getName().equals(angreifer.name))
		{
			anzAttacks = anzAttacks+1;
			
			if ((getEnergy()<50 && anzAttacks > 2) || anzAttacks >3) // Teammate um Hilfe bitten
			{
				try
				{
					broadcastMessage(e.getName()); // wird global gesendet falls team auf mehr wie 2 erweitert wird
				}
				catch (IOException ex)
				{
					out.println("Fehler beim Senden des Hilferuf!"+getName());
				}
			}
		}
		else // Angreiferobjekt belegen wenn neuer Attacker
		{
			angreifer.name = e.getName();
			angreifer.live = true;
			anzAttacks=1;
		}
	}

	public void onHitRobot(HitRobotEvent e) // Verhalten wenn man von einem anderen Bot gerammt wird - Thorsten Heck
	{
		if (isTeammate(e.getName()))
		{
			try
			{
				sendMessage(e.getName(), "FriendlyRam");
			}
			catch (IOException ex)
			{
				out.println("Fehler beim Senden von FriendlyRam!"+getName());
			}
			target.distance = 10000;
		}
	}
	
	public void onMessageReceived(MessageEvent e) // Teamkommunikation (Eingang) - Daniel Thorn
	{
		if (e.getMessage().equals("FriendlyFire"))
		{
			target.distance = 10000; // suche ein anderes Target
		}
		else if (e.getMessage().equals("FriendlyRam"))
		{
			target.distance = 10000;
		}
		else if (e.getMessage().equals(target.name)) // tma könnte aktuelles targe sein
		{
			try
			{
				broadcastMessage("Mine");
			}
			catch (IOException ex)
			{
				out.println("Fehler beim Senden von Mine!"+getName());
			}
		}
		else if (e.getMessage().equals("Mine"))
		{
			return;
		}
		else
		{
			tma.name = e.getMessage().toString();
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		Enemy en = (Enemy)targets.get(e.getName());
		en.live = false;		
		// check ob es sich um Angreifer oder TMA handelt - Thorsten Heck
		if(e.getName().equals(angreifer.name))
		{
			angreifer.live=false;
		}
		if(e.getName().equals(tma.name))
		{
			tma.live=false;
		}
	}	
	
	public void onWin(WinEvent e) // Verhalten bei Sieg - Thorsten Heck
	{
		out.println("Bow down to the king !");
	}

/************************************************************** Mathematische Hilfsfunktionen (Thorsten Heck) ************************************************************/

	// Berechnung des kleinsten Winkels, wenn dieser außerhalb von +/- PI liegt
	double normaliseBearing(double ang) {
		if (ang > Math.PI)
		{
			ang -= 2*Math.PI;
			return ang;
		}
		else if (ang < -Math.PI)
		{
			ang += 2*Math.PI;
			return ang;
		}
		else
		{
			return ang;
		}
	}
	
	// Berechnung des kleinsten Peilungswinkel, wenn dieser außerhalb von 0 und 2 PI liegt
	double normaliseHeading(double ang) {
		if (ang > 2*Math.PI)
		{
			ang -= 2*Math.PI;
			return ang;
		}
		else if (ang < 0)
		{
			ang += 2*Math.PI;
			return ang;
		}
		else
		{
			return ang;
		}
	}

	/**Turns the shortest angle possible to come to a heading, then returns the direction the
	the bot needs to move in. aus AntiGravBot von Alisdair Owens**/
	int turnTo(double angle) {
	    double ang;
    	int dir;
	    ang = normaliseBearing(getHeading() - angle);
	    if (ang > 90) {
	        ang -= 180;
	        dir = -1;
	    }
	    else if (ang < -90) {
	        ang += 180;
	        dir = -1;
	    }
	    else {
	        dir = 1;
	    }
	    setTurnLeft(ang);
	    return dir;
	}

	//Berechnung der Distanz zw. 2 Koordinaten
	public double getRange( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = Math.sqrt( xo*xo + yo*yo );
		return h;	
	}
			
	//Berechnung des absoluten Winkel zw. 2 Koordinaten
	public double absbearing( double x1,double y1, double x2,double y2 )
	{
		double xo = x2-x1;
		double yo = y2-y1;
		double h = getRange( x1,y1, x2,y2 );
		if( xo > 0 && yo > 0 )
		{
			return Math.asin( xo / h );
		}
		else if( xo > 0 && yo < 0 )
		{
			return Math.PI - Math.asin( xo / h );
		}
		else if( xo < 0 && yo < 0 )
		{
			return Math.PI + Math.asin( -xo / h );
		}
		else if( xo < 0 && yo > 0 )
		{
			return 2.0*Math.PI - Math.asin( -xo / h );
		}
		else
		{
			return 0;
		}
	}
}

class Enemy { // Feindklasse enthält alle relevanten informationen über den Feind - Ursprünglich aus AntiGravityBot, jedoch umfangreich ausgebaut - Daniel Thorn
	
	String name;
	public double bearing;
	public double changehead;
	public long ctime; // game time that the scan was produced
	public double distance;
	public double head;
	public double heading;
	public boolean live; // is en alive?
	public double speed;
	public boolean teammate;
	public double x,y;
	
	public String getName () {return name;}
	public double getBearing() {return bearing;}
	public double getChangeheat() {return changehead;}
	public long getCtime() {return ctime;}
	public double getDistance(){return distance;}
	public double getHeading () {return heading;}
	public double getHead() {return head;}
	public boolean getLive() {return live;}
	public double getSpeed () {return speed;}
	public boolean getTeammate() {return teammate;}
	public double getX() {return x;}
	public double getY() {return y;} 
	
	public Point2D.Double guessPosition(long when) {
		double diff = when - ctime;
		double newY = y + Math.cos(heading) * speed * diff;
		double newX = x + Math.sin(heading) * speed * diff;
		
		return new Point2D.Double(newX, newY);
	}
}

/**Holds the x, y, and strength info of a gravity point (from AntiGravityBot) **/
class GravPoint {
    public double x,y,power;
    public GravPoint(double pX,double pY,double pPower) {
        x = pX;
        y = pY;
        power = pPower;
    }
}
