package ss2010.Saarlodris;

import java.awt.Color;
import robocode.*;
import robocode.util.Utils;

/**
 * @author Pascal Jung, Sebastian Keller, David Ulrich
 * @version 0.1 Beta
 */
public class Wusselchjer extends TeamRobot
{
    private int strategy = 0;
    private String rival;
    private int NumbersTeammates = 0;
    static final double dodgeDir = 1;
    private final double BASE_TURN = Math.PI/2; // entsprechen 90° im Bogenmaß

    private long time;
    private double lastRivalDistance;
    private double startNumberRival;
    private double movement;
    static double lastEnergy;
    static int dodgeCount;




    /**
     * Diese Main-Methode ist bei jedem Roboter vorhanden und muss überschrieben
     * werden um die Basis-Verhalten jeden Roboter festzulegen.
     * <p>
     * <li> setColors wird gesetzt
     * <li> setAdjustGunForRobotTurn wird gesetzt
     * <li> turnRadarRight wird gesetzt
     * <p>
     * Desweiteren werden noch die Klassenvariablen
     * <li> NumbersTeammates
     * <li> movement
     * <li> startNumberRival
     */
    @Override
    public void run()
    {
        setColors(Color.black,Color.yellow,Color.red);

        movement = Double.POSITIVE_INFINITY;


        for(int i = 0; getTeammates().length > i; i++)
        {
            NumbersTeammates++;
        }
        out.println(NumbersTeammates);

        setAdjustGunForRobotTurn(true);

        startNumberRival = getOthers()-NumbersTeammates;

        setTurnRadarRight(Double.POSITIVE_INFINITY);

        switcher();
    }

    /**
     * Hier wird überprüft ob die Strategie geändert werden muss,
     * in dem die Methode switcher aufgerufen wird.
     * Wird aufgerufen, wenn er einen Roboter gescant hat.
     * <p>
     * Wenn er gegen einen anderen Roboter fährt, macht er folgendes.
     * <li> strategy auf 0 gesetzt
     * <br> führt er die Methode onScannedRobotPassive aus
     * <li> strategy auf 1 gesetzt
     * <br> führt er die Methode onScannedRobotPassive aus
     * <br> und
     * <br> die Methode movementPassiv
     * <li> strategy auf 2 gesetzt
     * <br> führt er die Methode onScannedRobotActive aus
     *
     * @param event The scanned-robot event set by the game
     */
    @Override
    public void onScannedRobot(ScannedRobotEvent event)
    {
        if(strategy == 2)
        {
            onScannedRobotActive(event);
        }
        else if(strategy == 1)
        {
            onScannedRobotPassive(event);
            movementPassiv();
        }
        else
        {
            onScannedRobotPassive(event);
        }
    }

    /**
     * Hier wird überprüft ob die Strategie geändert werden muss,
     * in dem die Methode switcher aufgerufen wird.
     * Wird aufgerufen, wenn der Roboter von einer Kugel getroffen wird.
     * <p>
     * Wenn er gegen einen anderen Roboter fährt, macht er folgendes:
     * <li> strategy auf 0 gesetzt
      * <li> fahre ein zufällige strecke von 0-200 und drehe dich dabei um eine zufällige grad Zahl von 0-180°(Bogenmaß)
     *
     * @param event The hit-by-Bullet event set by the game
     */
    @Override
    public void onHitByBullet(HitByBulletEvent event)
    {
        if(strategy == 0)
        {
            setAhead(Math.random()*200);
            setTurnRight(Math.random()*180);
        }
    }

    /**
     * Hier wird überprüft ob die Strategie geändert werden muss,
     * in dem die Methode switcher aufgerufen wird.
     * Wird aufgerufen, wenn der Roboter gegen einen Wand fährt.
     * <p>
     * Wenn er gegen einen anderen Roboter fährt, macht er folgendes:
     * <li> strategy auf 0 gesetzt
      * <li> fahre ein zufällige strecke von 0-200 und drehe dich dabei um eine zufällige grad Zahl von 0-180°(Bogenmaß)
     *
     * @param event The hit-Wall event set by the game
     */
    @Override
    public void onHitWall(HitWallEvent event)
    {
        if(strategy == 0)
        {
            setAhead(Math.random()*200);
            setTurnRight(Math.random()*180);
        }
    }

    /**
     * Hier wird überprüft ob die Strategie geändert werden muss,
     * in dem die Methode switcher aufgerufen wird.
     * Wird aufgerufen, wenn der Roboter gegen einen anderen Roboter fährt.
     * <p>
     * Wenn er gegen einen anderen Roboter fährt, macht er folgendes.
     * <ul> strategy auf 0 gesetzt
     * <li> fahre ein zufällige strecke von 0-200 und drehe dich dabei um eine zufällige grad Zahl von 0-180°(Bogenmaß)
     *
     * @param event The hit-robot event set by the game
     */
    @Override
    public void onHitRobot(HitRobotEvent event)
    {
        if(strategy == 0)
        {
            setAhead(Math.random()*200);
            setTurnRight(Math.random()*180);
        }
    }

    /**
     * Hier wird überprüft ob die Strategie geändert werden muss,
     * in dem die Methode switcher aufgerufen wird.
     * Wird aufgerufen, wenn ein anderer Roboter stribt.
     * @param event The robot-death event set by the game
     */
    @Override
    public void onRobotDeath(RobotDeathEvent event)
    {
        if(isTeammate(event.getName()))
        {
            NumbersTeammates--;
        }

        switcher();
    }


    /**
     * Diese Methode überprüft ob der Robter der gescant wurde ein Teammitglied
     * ist
     *
     * @param name Wird der name des Roboters übergeben
     * @return Gibt zurück ob es ein Teammate ist oder nicht
     */
    @Override
    public boolean isTeammate(String name)
    {
        for(int i = 0; getTeammates().length > i; i++)
        {
            String team1 = getTeammates()[i];
            String team2 = getTeammates()[i]+"*";

            if(team1.equals(name) || team2.equals(name))
            {
                return true;
            }
        }
        return false;
    }




    /**
     * Hier wird festgelegt, welche Strategie genutzt wird
     * anhand bestimmer Kriterien
     */
    private void switcher()
    {
        if(getOthers()-NumbersTeammates == 1)
        {
            strategy = 2;
        }
        else if(((getOthers()- NumbersTeammates) <6)
                || ((getOthers()-NumbersTeammates) < ((startNumberRival*3)/4)))
        {
            strategy = 1;
        }
        else
        {
            strategy = 0;
        }
    }


    /**
     * Hier sind die Methoden der Passiv Strategie
     */

    /**
     * Diese Methode überprüft als erst es ob es ein Teammitglied ist
     * und auf welchen Wert strategy geserival = e.getName()tzt ist.
     * Desweiteren wird geschaut, ob der gescante Gegner schon fixiert ist
     * oder ob noch kein Gegner fixiert ist. Es wird auch geschaut,
     * ob wir innerhalb der letzten 5 sek keinen rival mehr beschossen habe.
     *
     * @param e the scanned-robot event set by the game
     */
    private void onScannedRobotPassive(ScannedRobotEvent e)
    {

        if(isTeammate(e.getName()) == false)
        {
            if(rival == null)
            {
                rival = e.getName();
                aimAndShootPassive(e);
            }
            else if(lastRivalDistance > e.getDistance())
            {
                aimAndShootPassive(e);
                rival = e.getName();
            }
            else if(e.getName().equals(rival) == false && getTime()>time+5)
            {
               rival = null;
            }
        }

    }

    /**
     * Hier wird die Passiv Strategie um eine Movement Methode erweitert
     */

    /**
     * Quelle: www.robowiki.net<br>
     * Genauer Link: http://www.robowiki.net/wiki/Linear_Targeting#Example_of_Noniterative_Linear_Targeting<br>
     * Author: Unbekannt <br>
     * <p>
     * Diese Methode richtet die Kanone aus und wie viel er vorraus zielen muss
     * um den Gegner zu treffen.
     *
     * @param e the scanned-robot event set by the game
     */
    private void aimAndShootPassive(ScannedRobotEvent e)
    {
        double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
        setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing -
        getGunHeadingRadians() + (e.getVelocity() * Math.sin(e.getHeadingRadians() -
        absoluteBearing) / 11.0)));
        setFire(3.0);
        time= getTime();
        lastRivalDistance = e.getDistance();
    }

    /**
     * Da die Methode permanent durch ein scan event aufgerufen wird läuft sie endlos
     * dadurch fährt er im Kreis
     */

    /**
     * Quelle: www.robowiki.net<br>
     * Author: Miked0801  (http://robowiki.net/wiki/User:Miked0801)<br>
     * Url zum Robot: http://www.robowiki.net/wiki/Infinity <br>
     *                http://darkcanuck.net/rumble/robots/mld.Infinity_2.2.jar
     * <p>
     * sobald der Roboter sich nicht mehr bewegt, weil er gegen die Wand oder
     * einen anderen Roboter gefahren ist.
     * Dreht er sich um 90° nach rechts und die zu fahrende Distanz wird invertiert.
     */
    private void movementPassiv()
    {
        if(getDistanceRemaining() == 0)
        {
            setAhead(movement = -movement);
            setTurnRightRadians(BASE_TURN);
        }
    }


    /**
     * hier sind die Methoden der Aktiv Strategie
     */

   /**
     * Diese Methode überprüft als erst es ob es ein Teammitglied ist
     * und auf welchen Wert strategy gesetzt ist.
     * Desweiteren wird geschaut, ob der gescante Gegner schon fixiert ist
     * oder ob noch kein Gegner fixiert ist. Es wird auch geschaut,
     * ob wir innerhalb der letzten 5 sek keinen rival mehr beschossen habe.
     *
     * @param e the scanned-robot event set by the game
     */
    private void onScannedRobotActive(ScannedRobotEvent e)
    {
        if(isTeammate(e.getName()) == false)
        {
            if(rival == null)
            {
                rival = e.getName();
                aimAndShootActive(e);
            }
            else if(e.getName().equals(rival))
            {
                aimAndShootActive(e);
            }
            else if(e.getName().equals(rival) == false && time+5 < getTime())
            {
                rival = null;
            }
        }
    }

    /**
     * Quelle: www.robowiki.net <br>
     * Author: Miked0801  (http://robowiki.net/wiki/User:Miked0801) <br>
     * Url zum Robot: http://robowiki.net/wiki/Tide <br>
     *                http://robocoderepository.com/BotDetail.jsp?id=3639 <br>
     *<br>
     * Modifiziert durch Pascal Jung
     * <p>
     * Mittels dieser Methode wird auf den Gegner zugefahren
     * geschossen und gerammt. Wenn der Gegner Energie verliert und wir noch
     * weiter als 170 entfernt sind fahren wir kleine Kurven.
     *
     * @param e the scanned-robot event set by the game
     */
    private void aimAndShootActive(ScannedRobotEvent e)
    {
        int direction = (Math.cos(e.getBearingRadians()) >= 0.0D) ? 100 : -100;
        double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
        double dodgeValue = 0;
        double leadValue = Math.asin(e.getVelocity() / 11) * Math.sin(e.getHeadingRadians() - absoluteBearing);
        if(lastEnergy > (lastEnergy = e.getEnergy()) && e.getDistance() > 170)
        {
            dodgeCount = 7;
        }
        if(dodgeCount > 0)
        {
            dodgeCount--;
            dodgeValue = dodgeDir;
        }
        setTurnRightRadians(robocode.util.Utils.normalRelativeAngle( dodgeValue + e.getBearingRadians() + leadValue));

        if(getGunTurnRemaining() == 0)
        {
            setFire(660 / e.getDistance());
        }


        setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + leadValue ));

        setAhead(direction);

        setMaxVelocity(Math.abs(getTurnRemainingRadians()) > 1 && e.getDistance() < 200 ? 0 : 8);

        setTurnRadarLeft(getRadarTurnRemaining());

        time= getTime();
    }

    /**
     * Main Methode ist drin, damit ich es einfacher compilieren kann mit
     * Netbeans
     */
    public static void main(String[] args)
    {
        System.out.println("Wusselchjer ist gebaut");
    }

}
