package ss2010.MadeInChina;
import robocode.*;
import java.awt.Color;
import java.io.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;

/**
 * R2D2 - a robot by (Haze)
 */
public class R2D2 extends TeamRobot
{
	int noTarget = 0, counter = 0;			// Zählt wie lange kein Ziel gesichtet wurde
	String target = null;					// Merkt sich das Ziel
	
	/**
	 * run: R2D2's default behavior
	 */
	public void run() 
	{
		setColors(Color.black,Color.red,Color.yellow);
		setAdjustRadarForRobotTurn(true);	// Radar und Robot drehen sich unabhängig voneinander
		setAdjustGunForRobotTurn(true);		//Gun und Robot drehen sich unabhängig voneinander
		setAdjustRadarForGunTurn(true);		//Radar und Gun drehen sich unabhängig voneinander
		
		while(true) 
		{	
			turnRadarRight(360);
			noTarget++;						// Zählt wie lange kein Ziel gesichtet wurde
			
			if (noTarget >= 2)
			{
				target = null;				// Länger als 2 Züge ohne Target = neues Target (Test ob 20 Züge zu viel oder zu wenig steht noch aus)
				noTarget = 0;
			}
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		chDirCheck(e);
		WallSystem.dir((TeamRobot)this,e,counter);		// Startet WallSystem (näheres dazu in der Klasse selbst)
		
		if (e.getName().equals("ss2010.MadeInChina.C3PO") || e.getName().equals("ss2010.MadeInChina.C3PO*"))	// Don't fire on teammates
		{
			return;
		}
			else if (e.getName().equals(target) || target == null)
			{
				target = e.getName();		//Ziel wird festgelegt und gespeichert
					
				WeaponSystem.tar((TeamRobot)this,e);		// Startet WeaponSystem (näheres dazu in der Klasse selbst)
				
				MovementSystem.off((TeamRobot)this,e);		// Startet MevementSystem (näheres dazu in der Klasse selbst)
				
				if(getOthers() <=3)
				{
					counter = 2;
				}
			
				chDirCheck(e);
				WallSystem.dir((TeamRobot)this,e,counter);
		}
	}

	public void onHitWall(HitWallEvent e)	//Wenn wir eine Wand rammen
	{	
		MovementSystem.chDir();
	}
	
	public void onMessageReceived(MessageEvent e) 
	{	
		try
		{
			out.println("Sende Ziel " + target);
			sendMessage("ss2010.MadeInChina.C3PO",target); // Senden des gemeinsamen Ziels
		}
			catch(IOException ex)
			{ 
				out.println("Fehler beim senden!"+getName()); // Abfangen von eventuellen Fehlern 
			}												

	}

	public void onHitRobot(HitRobotEvent e)
	{
		MovementSystem.chDir();
	}

	public void chDirCheck (ScannedRobotEvent e)
	{
		if (WallSystem.wallDistance((TeamRobot)this,e) == true)
		{
			counter = 0;
		}
			else if (WallSystem.wallDistance((TeamRobot)this,e) == false)
			{
				counter = 1;
			}
	}
}
