package ss2010.Hulk;
import java.awt.Color;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;


/**
 * BruceBanner - ein Robot von Thomas Vogt, Daniel Knerr und Patrick Stephan
 */
public class BruceBanner extends TeamRobot
{
	
	String enemyName = null;
	static double lastEnergy;
	static int dodgeCount;
	static double dodgeDir = 1;//Math.PI/4;
	double time;
	double hitTime;
	
	/**
	 * run: BruceBanner's Standardverhalten
	 */
	public void run() {
		out.println("run");
		// BruceBanner wird in schlichtem schwarz/weiß lackiert
		setBodyColor(Color.black);
		setGunColor(Color.white);
		setRadarColor(Color.black);
		setBulletColor(Color.red);
		setScanColor(Color.black);
		execute();
		
		// Das Standardverhalten wurde vom freien Robot "tide" aus dem RoboWiki übernommen
		setAdjustGunForRobotTurn(true);
		while(true){
			turnRadarRightRadians(Double.POSITIVE_INFINITY);
		}	
		// unreachable: dodgeDir = -dodgeDir;		
	}

	/**
	 * onScannedRobot: Was BruceBanner ausführt sobald er einen anderen Robot sieht
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		out.println("onScannedRobot");
		// Ist der gescannte Robot unser Teammate?
		if(teammate(e.getName())){ 
			// Ja, weiter scannen
			return;
		}	
		else{
			// Nein, es wird überprüft ob der Gegnerspeicher auf "null" steht,... 
			if(enemyName == null){
				// ...dann wird dieser auf den gescannten Robot gesetzt...
				enemyName=e.getName();
				out.println("Neuer Gegner");
				//... der Scanzeitpunkt wird festgehalten...
				time=(double)getTime();
				// ...und die Angriffsroutine wird aufgerufen
				attack(e);
			// Nein, es wird überprüft ob der Robot der aktuell gespeicherte Gegner ist...
			}else if(e.getName().equals(enemyName)){
				// ...der Name wird erneut gesetzt...
				enemyName=e.getName();
				// ... die neue Scanzeit wird festgehalten...
				time=(double)getTime();
				// ...und die Angriffsroutine wird aufgerufen
				attack(e);
			// Nein, es wird 10 Zeiteinheiten versucht den Gegner zu finden...
			}else if(getTime()>time+10){
				// ...klappt dies nicht, dann wird der Gegnerspeicher auf "null" gesetzt und es kann ein neuer Gegner ausgewählt werden
				enemyName=null;
			}
		}
	}

	/**
	 * onHitByBullet: Was BruceBanner ausführt wenn er getroffen wird
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		out.println("Aua, nich haun!");
	}

	/**
	 * onHitWall: Was BruceBanner ausführt wenn er gegen eine Wand fährt
	 */
	public void onHitWall(HitWallEvent e){
		out.println("Ups, hier gehts nicht weiter");
		
		// Die Ausweichroutine "avoiding()" wird aufgerufen
		avoiding();	
		
		// Die Zeit wird neu gesetzt da das Ausweichen nicht für das Timeout einbezogen werden darf
		time=getTime();
	}
	
	/**
	 * onHitRobot: Was BruceBanner ausführt wenn er gegen einen Robot fährt
	 */
	public void onHitRobot(HitRobotEvent e){
		out.println("Aus dem Weg!");

		// Die Ausweichroutine "avoiding()" wird aufgerufen
		avoiding();	
		
		// Die Zeit wird neu gesetzt da das Ausweichen nicht für das Timeout einbezogen werden darf
		time=getTime();
	}
	
	/**
	 * onWin: Was BruceBanner ausführt wenn er gewinnt
	 */
	public void onWin(WinEvent e){
		// BruceBanner freut sich wie ein Hochhaus und...
		// ... färbt sich in den deutschen Nationalfarben ...
		setBodyColor(Color.black);
		setGunColor(Color.red);
		setRadarColor(Color.yellow);
		setBulletColor(Color.red);
		setScanColor(Color.yellow);
		execute();
		// ... dreht sich wie wild im Kreis ...
		turnLeft(3600);
		// ... und freut sich
		out.println("Sieg!");
	}
	
	/**
	 * attack: BruceBanner's Angriffsroutine
	 */
	public void attack(ScannedRobotEvent e){
		out.println("attack");
		// Die Angriffsroutine ist die modifizierte Angriffsroutine des freien Robots "tide" aus dem RoboWiki. Die Modifizierungen werden an entsprechender Stelle erklärt
		int direction = (Math.cos(e.getBearingRadians()) >= 0.0D) ? 100 : -100;
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		double dodgeValue = 0;
		double leadValue = Math.asin(e.getVelocity() / 11) * Math.sin(e.getHeadingRadians() - absoluteBearing);
		
		// Ist der Gegner weiter als 140 Pixel entfernt?
		if(e.getDistance() > 140){
			// Ist der Gegner Näher als 325 Pixel entfernt, so wird das Dodging eingeleitet
			if(e.getDistance()<325)dodgeCount = 7 + (int)(Math.random() * 5);
			if(dodgeCount > 0){
				dodgeCount--;
				dodgeValue = dodgeDir;
			}
			setTurnRightRadians(robocode.util.Utils.normalRelativeAngle( dodgeValue + e.getBearingRadians() + leadValue));
			if(getGunTurnRemaining() == 0)
			// Ist der gescannte Robot unser Teammate?
			if(teammate(e.getName())){
				// Ja, Gegnerspeicher auf "null" setzen und weiter scannen
				enemyName=null;
				out.println("Nicht den Freund abschießen");
			}
			else{ 
				// Nein, Schussstärke berechnen und schießen
				setFire(660 / e.getDistance());
			}
															
			setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + leadValue ));																		
			setAhead(direction);
			setMaxVelocity(Math.abs(getTurnRemainingRadians()) > 1 && e.getDistance() < 200 ? 0 : 8);			
			setTurnRadarLeft(getRadarTurnRemaining());
		}
		// Der Gegner ist näher als 140 Pixel
		else{
			// Ist der Gegner Näher als 100 Pixel?
			if(e.getDistance()<100){
				// BruceBanner weicht nacht hinten aus...
				setBack(200);
				double randomizer=Math.random()*2;
				// ...entweder nach links mit 70 Grad...
				if(randomizer<=1)setTurnLeft(70);
				// ...oder nach rechts mit 70 Grad
				else setTurnRight(70);
				
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + leadValue ));	
				// Ist der gescannte Robot unser Teammate?
				if(teammate(e.getName())){
					// Ja, Gegnerspeicher auf "null" setzen und weiter scannen
					enemyName=null;
					out.println("Nicht den Freund abschießen");
				}
				else{
					// Nein, Schussstärke auf 3 setzen 
					setFire(3);
				}	
				// Ausführen!
				execute();
			}
			// Der Gegner ist mehr als 100 Pixel entfernt
			else{
				setTurnRightRadians(robocode.util.Utils.normalRelativeAngle( dodgeValue + e.getBearingRadians() + leadValue));
				if(getGunTurnRemaining() == 0)
				// Ist der gescannte Robot unser Teammate?
				if(teammate(e.getName())){
					// Ja, Gegnerspeicher auf "null" setzen und weiter scannen
					enemyName=null;
					out.println("Nicht den Freund abschießen");
				}
				else{ 
					// Nein, Schussstärke berechnen und schießen
					setFire(660 / e.getDistance());
				}
				
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians() + leadValue ));																
				setAhead(direction);
				setMaxVelocity(Math.abs(getTurnRemainingRadians()) > 1 && e.getDistance() < 200 ? 0 : 8);
				setTurnRadarLeft(getRadarTurnRemaining());			
			}
		}							
	}
	
	/**
	 * avoiding: BruceBanner's Ausweichroutine
	 */
	public void avoiding(){
		out.println("avoiding");
		// Zunächst wird die aktuelle Spielzeit genommen
		hitTime=getTime();
		// Nun probiert BruceBanner nach links auszuweichen
		if(getTime()<hitTime+5){
			out.println("avoiding,if");
			turnLeft(111);
			ahead(100);
		}
		// Klappt das nach 5 Zeiteinheiten nicht, so probiert BruceBanner es nach rechts
		else{
			out.println("avoiding,else");
			turnRight(111);
			ahead(100);
		}
	}

	/**
	 * teammate: BruceBanner's Ersatzroutine für isTeamMate
	 */
	public boolean teammate(String name){
		if(name.equals("ss2010.Hulk.Hulk"))return true;
		if(name.equals("ss2010.Hulk.Hulk*"))return true;
		else return false;	
	}	
}
