package ss2010.Desert_Weasel;

import robocode.*;
import java.io.IOException;
import robocode.TeamRobot;
import java.awt.Color;

/**
 * Giggle - ein Roboter von Tim Beckmann und Julian Riebel
 */
public class Giggle extends TeamRobot
{
	/**
	 * run: Giggle's Standardverhalten
	 */
		public void run() {
		
		setColors(Color.black,Color.red,Color.yellow); //Farben einstellen
		
		while(true) {	//Endlosschleife die bis zum zerstören des Roboters widerholt wird
			turnGunRight(90);
			turnRadarRight(360);
			turnLeft(45);
			setAhead(100);
		}
	}

	/**
	 * onScannedRobot: Verhalten, falls ein Roboter gescannt wurde
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(isTeammate(e.getName())||e.getName().equals("ss2010.Desert_Weasel.Gaucho_1")){	//überprüfen ob gescannter Roboter Teamkollege
			scan();						//Dann erneut scannen um anderes Ziel zu finden
		}
	 	else{		
			//Zielfunktion, basierend auf der Idee von Team 1 WS2006
			double distanz=e.getDistance();  //Distanz zum gescannten Roboter
		   	double enemyBearing = this.getHeading() + e.getBearing(); //Richtung zum gescannten Feind
           	double enemyX = getX() + e.getDistance() * Math.sin(Math.toRadians(enemyBearing)); //ermitteln der X-Koordinate des Feindes
       		double enemyY = getY() + e.getDistance() * Math.cos(Math.toRadians(enemyBearing)); //ermitteln der Y-Koordinate des Feindes
       		double ourX = getX(); //ermitteln der eigene X-Koordinate
           	double ourY = getY(); //ermitteln der eigene Y-Koordinate
           	double dx = enemyX - ourX; //Differenz zwischen eigener und Feindposition X
           	double dy = enemyY - ourY; //Differenz zwischen eigener und Feindposition Y
       		double theta = Math.toDegrees(Math.atan2(dx, dy)); //Winkelberechnung
           	double angle = normalRelativeAngle(theta - getGunHeading()); //Relativer Winkel zum Feind

			turnGunRight(angle);	//Kanone auf feindlichen Panzer ausrichten
			
			if (getGunHeat() == 0) {	//überprüfen ob Kanone kalt genug
				if(distanz<=100)  fire(3);	//je nach Distanz zum Gegner die Feuerkraft variieren
				else if(distanz>100&&distanz<=200)  fire(2);
				else fire(1);
			}
		}
	}

	/**
	 * onHitByBullet: Verhalten, wenn Roboter von Kugel getroffen wurde
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		if(isTeammate(e.getName())||e.getName().equals("ss2010.Desert_Weasel.Gaucho_1")){		//überprüfen, ob Kugel von Teamkollegen
			try{		
				broadcastMessage("Feuer einstellen!");		//Nachricht an anderen Roboter senden
				System.out.println("Feuer einstellen!");
			}
				catch(IOException ex){		//mögliche Fehler bei der Nachrichtenübermittlung abfangen
				out.println("Fehler beim Senden der Nachricht von"+getName());
				}		
		}
		else{
			setTurnRight(e.getBearing()+90);	//von der Schussrichtung wegdrehen und 
			setAhead(100);						//fliehen
		}
			
	}

	/**
	 * onHitWall: Verhalten, wenn Roboter an die Wand fährt
	 */
	public void onHitWall(HitWallEvent e) {
		turnRight(180+e.getBearing());	//um 180 von dem Auftreffwinkel wegdrehen und 
		ahead(200);						//wieder in das Spielfeld hinein fahren
	}

	/**
	 * onHitRobot: Verhalten, wenn Roboter mit anderem Roboter kollidiert
	 */
	public void onHitRobot(HitRobotEvent e){  // wenn ein Roboter gerammt wird
						
		if(isTeammate(e.getName())||e.getName().equals("ss2010.Desert_Weasel.Gaucho_1")) {  //überprüfen ob gescannter Roboter Teamkollege
				
				setTurnRight(90);  //falls Teamkollege, um 90 Grad nach rechts drehen und
				setBack(150);  	// setze um 150 zurück
		}
		
		else{  //wenn gescannter Roboter ein Feind
	
			if(e.getBearing()>=-90&&e.getBearing()<= 90){  //wenn der Auftreffwinkel relativ zur eigenen Fahrtrichtung zwischen -90° und 90° liegt
				setBack(100); 	//100 zurücksetzen
			}
			else{   
				setAhead(100);  //sonst 100 vorwärts
			}
			double absoluteBearing = getHeading() + e.getBearing();		//Berechnen des absoluten Winkels zum Gegner
 			double kanonenwinkelHitRobot = normalRelativeAngle(absoluteBearing - getGunHeading());	//Berechnen des optimalen Winkels zur Drehung der Kanone, um Zeit zu sparen
			setTurnGunRight(kanonenwinkelHitRobot);	//Kanone zum Feind drehen und
				fire(3);						//mit voller Kraft feuern
		}
	}


	/**
	 * normalRelativeAngle:  Hilfsfunktion, die den Winkel optimiert
	 */
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {		//falls der Winkel bereits zwischen > -180 und <= 180 Grad liegt, 
			return angle;						//wird er wieder zurückgegeben
		}
		double fixedAngle = angle;
		if (fixedAngle <= -180) {		//wenn der Winkel <= -180 Grad ist, werden 360 dazu addiert
			fixedAngle += 360;
		}
		if (fixedAngle > 180) {
			fixedAngle -= 360;			//wenn der Winkel > 180 Grad ist, werden 360 subtrahiert
		}
		return fixedAngle;
	}

	/**
	 * onMasseageRecieved:  bei erhalten einer Nachricht vom Teamkollegen Feuer einstellen
	 */
	public void onMessageRecieved(MessageEvent e){
		if(e.getMessage().equals("Feuer einstellen!")){		//wenn eine Nachricht dieser Art empfangen wird, 
			scan();											//wird ein manueller Scan gestartet, um einen neuen Feind zu finden
		}
	}

	/**
	 * onWin:  bei einem Sieg die Farben auf Gelb setzen und Panzer und Radar 360 Grad nach rechts und Kanone 360 Grad nach links drehen
	 */
	public void onWin(WinEvent e) {
		
		setColors(Color.yellow,Color.yellow,Color.yellow);
		for (int i = 0; i < 40; i++) {
			turnRight(360);
			turnGunLeft(360);
			turnRadarRight(360);
		}
	}
}
