package kk;
import robocode.*;
import java.awt.Color;

/*
 * Schweinepest - a team robot by Klaus Knopper,
 * based on "Tracker"
 * 
 * Verfolgt den Gegner bis zum bitteren Ende und lässt sich nicht abschütteln.
 * Neu: Vorausberechnung der Gegnerposition.
 */
public class Schweinepest extends TeamRobot {
 public String currentEnemyName      = null;
 public double currentEnemyDistance  = 10000;
 public double radarTurnAngle        = 16;
 public int count                    = 0;
 
 public void run() {
  setAdjustGunForRobotTurn(true);  // Keep the gun still when we turn
  currentEnemyName = null;         // No current enemy
  // The only thing we do here is move the radar
  while (true) {
   if(currentEnemyName == null) {
    setColors(Color.green,Color.green,Color.green);
    turnRadarLeft(360);
    count = 0;
   } else {
    radarTurnAngle = -radarTurnAngle;
    turnRadarLeft((count==0?radarTurnAngle/2.0:radarTurnAngle)+getRadarTurnRemaining());
    count++;
    if(count>6) currentEnemyName = null;
   }
  }
 }

 public void onRobotDeath(RobotDeathEvent e) {
  if(currentEnemyName != null && e.getName().equals(currentEnemyName)) {
   // The robot we are trying to kill just died.
   // Force to select another one.
   currentEnemyName     = null;
   currentEnemyDistance = 10000;
   out.println("RIP: " + currentEnemyName +
               ", suche neues Opfer.");
   setColors(Color.yellow,Color.yellow,Color.yellow);
  }
 }
	
 // If this robot is closer to us, try to track him instead of the current one
 public synchronized void maybeTrackRobot(String name, double bearing, double distance, boolean priority) {
  boolean aligngun = false;
  // Don't fire on teammates
  if(isTeammate(name)) return;
  if(currentEnemyName == null) {
   aligngun=true; currentEnemyName = name;
   setColors(Color.red,Color.red,Color.red);
   out.println("Neues Opfer: " + name);
  }
  if(priority) {
   if(!name.equals(currentEnemyName)) {
    aligngun=true; currentEnemyName = name;
    out.println("Neues Hauptopfer: " + name);
    setColors(Color.red,Color.red,Color.red);
   }
  }
  // Follow the name we are tracking, ignore all others
  if(!name.equals(currentEnemyName)) return;
  currentEnemyDistance = distance;
  setTurnGunRight(normalRelativeAngle(bearing+getHeading()-getGunHeading()));
  if(aligngun) {
   setTurnRadarRight(normalRelativeAngle(getGunHeading()-getRadarHeading()));
  }
  setTurnRight(bearing);
  // If our target is too far away, turn and move torward it.
  if(distance > 60) {
   setAhead(distance);
  }
  // Our target is too close!  Back up.
  if (distance < 55) {
   setBack(5);
  }
 }

 public void smartFire(double strength) { if(getGunHeat()==0) setFire(strength); }

 public void onScannedRobot(ScannedRobotEvent e) {
  double bearingFromGun = normalRelativeAngle(e.getBearing() + getHeading() - getGunHeading());

  if(e.getDistance() <= 60) smartFire(3);
  else if(e.getDistance() <= 100) smartFire(2);
  else if(e.getDistance() <= 200) smartFire(1);

  if(currentEnemyName != null && currentEnemyName.equals(e.getName())) count=2; // We still keep trak of our target
  maybeTrackRobot(e.getName(),e.getBearing(),e.getDistance(),false);
 }

 public void onWin(WinEvent e) {
  setColors(Color.yellow,Color.yellow,Color.yellow);
  out.println("Gewonnen. :-)"); turnRight(3*360);
  stop();
 }

 // Helper functions
 public double normalRelativeAngle(double angle) {
  if (angle > -180 && angle <= 180) return angle;
  double fixedAngle = angle;
  while (fixedAngle <= -180) fixedAngle += 360;
  while (fixedAngle > 180)   fixedAngle -= 360;
  return fixedAngle;
 }
}