// Team SearchandDestroy
// import the source
package ss2007.Team4;
import robocode.*;
import java.awt.Color;
import java.io.*;

/**
 * Sucher - a robot by (Markus Schiel)
 */
public class Sucher extends TeamRobot
{
	
	// Variablen deklaration
	public int count=0;
	public int count3=0;
	public double energy;
	public double geschwindigkeit;
	public double ergebnis =100;
	public String name ="Begin";
	public String name2 ="Begin";
	public String namenow ="Begin";
	public int count2 = 0;
	public double entfernung;
	public double bearing;
	public double heading;
	public double radar;
	public String TargetName;
	
	// Die Standard Ttigkeiten des Suchers
	public void run() {		
		while (true){
			setColors(Color.blue,Color.blue,Color.green); // Farbe des Robots
				if(count==0){
					turnRadarRight(360);				  // Dreht das Radar um 360 Grad rechts herum
				}
					else
					{
					for(int i=0;i<12;i++){				  // Durchluft die Schleife 11 mal und verndert damit das Radar von Rechts 30 Grad nach Links 30 Grad
					turnRadarRight(30);
					turnRadarLeft(30);		
					}
					count=0;
					}		
				}
	}

	/**
	 * Der Robot Sucher fhrt nach Erkennung eines Gegners folgendes aus...
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	    if (isTeammate(e.getName())) {
			return;
		}
	// Hier wird die bergabe vom Teamrobot berprft
		if (TargetName != null){
			if (!TargetName.equals(e.getName())) {return;}	
		}
			
	// Zuweisung der Werte des gegnerischen bzw. des Robots Suchers!
	count =1;
	turnRadarRight(getRadarTurnRemaining());			   // getRadarTurnRemaining() Gibt die Grad Zahl zurck bei dem das Radar einen gegnerischen Robot gesehen hat
														   // und gleichzeitig wird das Radar durch diesen Wert nach Rechts geschwenkt!
	entfernung = e.getDistance();						   // Holt die Distance zum gegnerischen Roboter
	bearing = e.getBearing();							   // Holt die Grad zum gegnerischen Roboter im Bezug auf die Stellung des eigenen Roboters
	heading = getHeading();								   // Holt die Grad von eigenen Roboter
	radar = getRadarHeading();							   // Holt die Grad vom Radar
	geschwindigkeit =e.getVelocity();					   // Holt die Geschwindigkeit des gegnerischen Robots
	setScanColor(new Color(251,251,251));				   // Setzt die Radar Farbe auf Wei
	setColors(Color.red,Color.red,Color.green); 		   // Verndert die Farbe da der Robot nun ein Ziel gefunden hat bzw. ein gegnerischer Robot ins Radar kam!
		
	// Wenn nur ein gegnerischer Roboter da ist und die Energy kleiner ist dann wird er gerammt auf Ihn zugefahren und beschossen!
	if (e.getEnergy()<getEnergy() && getOthers() == 1){
		bewegung(bearing, entfernung+100);
		feuerkraft(entfernung, geschwindigkeit);
		}
		else
			{
			bewegung(bearing, entfernung);
			feuerkraft(entfernung, geschwindigkeit);
			}
	}

	// Klasse welche nach dem der Sucher 3 mal vom selben gegnerischen Robot getroffen wurde den TeamRobot um Hilfe ruft!
	public void onHitByBullet(HitByBulletEvent e) {
		name = e.getName();
		if(name==name2){
			count3++;
			if(count3 ==3){
				// Hier wird der Name des gegnerischen Robots zum TeamRobot verschickt
				try{broadcastMessage(new Message(name));
				count3=0;
				}
				catch (IOException Ex){}
			}
		}
			else
				{
				count3=0;
				name2=name;
				}
	}

	// Klasse zum ausweichen der Wand
	public void onHitWall(HitWallEvent e) {
		setAhead(5); // Hier wird nur vorwrts gefahren da der Sucher nur durch Bedrngung eines Gegners an die Wand gedrckt wird!
	}

	// Klassen fr Feuerkraft
	public void feuerkraft(double entfernung, double geschwindigkeit){
	if(geschwindigkeit <= 3)	{								      // Ist gegnerischer Roboter langsamer oder gleich 3 Pixel / Turns dann,
		setColors(Color.black,Color.black,Color.black);				  // Frbt er die Farbe Schwarz und welchselt diese mit Rot
		if(entfernung <150){ fire(3);}						   	      // und wenn die Entfernung kleiner als 150 Pixel ist wird mit der Feuerkraft 3 geschossen
			else{
			if(entfernung <400){ fire(1);}							  // und wenn die Entfernung kleiner als 400 Pixel ist wird mit der Feuerkraft 1 geschossen
				else {
				if(entfernung <400)	{							      // Ist der gegnerische Roboter schneller als 3 Pixel / Turn unterwegs und die Entfernung ist kleiner als 400
				fire(1);}}}}				                          // 400 Pixel dann wird mit der Feuerkraft 1 geschossen
	}

	//Klassen fr Bewegung
	public void bewegung(double bearing, double entfernung){
		bearing = normalRelativeAngle(bearing);				   // Einsetzen der Gradzahl des Gegners in die normalRelativeAngle Funktion, welche die Zahl umwandelt 180-180
		setTurnRight(bearing);								   // Roboter dreht nach Rechts mit positiver Gradzahl nach Links mit negativer Gradzahl
		setAhead(entfernung-100);							   // Roboter geht vorwrts mit der aktuellen Entfernung zum gegnerischen Roboter minus 100 Pixel
	}

	// Klasse welche die Nachrichten des Team Robots empfngt diese enthlt den Namen des Angreifers!
	public void onMessageReceived(MessageEvent e) {
		Message p = (Message) e.getMessage();
		TargetName = p.getTargetName();									// Nimmt den Namen aus dem Event und speichert Ihn ab
		out.println("Helf Teammitglied -> Neues Ziel:"+ TargetName);	// Ausgabe auf Kommandozeile
	}

	// Klasse welche den Sucher vom Angestoenen Robot wegfhrt!
	public void onHitRobot(HitRobotEvent e){
		bewegung(e.getBearing(), 150);	
	}

	// Klasse welche erkennt wann ein Robot gekillt wurde! (Sinn: Setzt die Variable TargetName = null damit der Sucher neue Robots scannen kann)
	public void onRobotDeath(RobotDeathEvent e){
	if(TargetName != null){										
		if (TargetName.equals(e.getName())){TargetName=null;}
	}	
	}

	// Klasse welche die getBearing() Gradzahl umrechnet und wieder ausgibt! (Sinn: Wandelt den getBearing in eine Zahl zwischen 180 Grad und -180 Grad um)
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}			
}
