// Team FlitschFlatsch
package ss2007.Team3;
import robocode.*;
import robocode.util.*;
import java.lang.*;
import java.awt.Color;
import java.awt.geom.*;
import java.io.*;

/**
 * FrankTheTank - a robot by 
 * Ideas: Andre Sres, Florian Peifer and Andreas Fritzler
 * Implementation & Comments: Andre Sres
 */
public class FrankTheTank extends TeamRobot
{
	/**
	 * Die run Methode bestimmt das Verhalten des Roboter's solange kein Ereigniss eingetreten ist
	 */
	
	public void run() {
		
		// Die Kanone soll abhaengig der Bewegung des Roboter drehen
		setAdjustGunForRobotTurn(true); 
		/*
		* Mit set...Color werden die Farben des Roboters bestimmt
		*/
		setBodyColor(new Color(85,107,47));
		setRadarColor(new Color(139,134,75));
		setGunColor(new Color(0,0,0));
		setBulletColor(new Color(255,255,255));
		
		//Solange noch mehrere Gegner im Spiel sind w�hle die Standardtaktik
		while(getOthers()>1) { 
			standardroutine();
		}
		//Sobald nur noch ein Gegner uebrig ist gehe zur �ber zur Verfolgungsstrategie
		while(getOthers()==1){ 
			verfolgungsroutine();
		}
	}

	/**
	 * Die Methode onScannedRobot bestimmt das Verhalten, wenn das Ereignis "Roboter gescannt" eingetreten ist
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if(!isTeammate(e.getName())){
			
			if(getOthers()==1){
				double bearingFromGun = winkelBerechnung(e.getBearing() + getHeading() - getGunHeading());
  				vorzielen(e,3);
  				verfolgung(e.getBearing(),e.getDistance());
			}
			double feuerstaerke=1;
			if(e.getDistance()<=600){
				if((e.getDistance()>200)&&(e.getDistance()<400)){
					feuerstaerke=2.0;
				}
				else if(e.getDistance()<200){
					feuerstaerke=3.0;
				}
				vorzielen(e,feuerstaerke);
				setAdjustRadarForGunTurn(true);
			} 
			else turnRadarRight(90);
		}
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
			//Drehe dich um 90 Grad gegen die Schussrichtung und laufe weg  
		setTurnLeft(90);
		setAhead(200);
		if(isTeammate(e.getName())){
			try{
				broadcastMessage("STOP FIRE");
			}
			catch(IOException ex){
			out.println("Fehler beim Senden der Nachricht von"+getName());
			}		
		}		
	}
	/*
	*/
	public void onHitWall(HitWallEvent e){
		if(getOthers()==1);//Wenn nur noch 1 Gegner im Spiel ist, tue nichts
		if(getOthers()>1){
			//Wenn du vorwaerts gegen die Wand f�hrst, fahre 200 Pixel zur�ck
			if(e.getBearing()<=90&&e.getBearing()>=-90){ 
				setTurnRight(0);
				setBack(200);
			}
			// Wenn du rueckwaerts gegen die Wand faehrst, fahre 200 Pixel nach vorne
			if(e.getBearing()>90){ 
				setTurnRight(0);
				setAhead(200);
			}
		}	
	}
	//Wenn der Gegner 10 Energipunkte weniger als Du hat, mach ihn fertig!
	public void onHitRobot(HitRobotEvent e){
		if(getOthers()==1){
			if(e.getEnergy()<getEnergy()-10){
				setTurnRadarRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				setTurnGunRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				fire(3);
			}
			else;
		}
		if(getOthers()>1&&!isTeammate(e.getName())){
			if(e.getEnergy()<getEnergy()-10){
				setTurnRadarRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				setTurnGunRight(winkelBerechnung(e.getBearing()+getHeading()-getGunHeading()));
				fire(3);
			}
			else {
				turnLeft(90 - e.getBearing());
				setAhead(100);
			}
		}

	}
	
	// Im Falle eines Gewinnes, wechsle die Farbe auf Gold und drehe den Koerper nach rechts, sowie die Kanone nach links
	public void onWin(WinEvent e) {  
		for (int i = 0; i <10; i++) {  
			setBodyColor(new Color(255,215,0));
			setGunColor(new Color(255,215,0));
			setRadarColor(new Color(255,215,0));
			turnRight(20);
			turnGunLeft(20);
		}
	}
	
	public void onMessageRecieved(MessageEvent e){
		if(e.getMessage().equals("STOP FIRE")){
			run();
		}
	}
	
	//Standardroutine bestimmt das Verhalten solange noch mehrer Gegner vorhanden sind 
	public void standardroutine(){ 
		turnRadarRight(360);
		setAhead(200);
		turnRight(90);		
	}
	//Verfolgungsroutine bestimmt das Standardverhalten, wenn nur noch 1 Gegner uebrig ist
	public void verfolgungsroutine(){ 
		turnRadarRight(360);
	}
	// Roboter verfolgt den Gegner bzw. uebernimmt dessen Laufverhalten
	public void verfolgung(double bearing, double distance){ 
		
		setTurnGunRight(winkelBerechnung(bearing+getHeading()-getGunHeading())); //Drehe Kanone in Richtung Gegner
  		setTurnRadarRight(winkelBerechnung(getGunHeading()-getRadarHeading())); //Drehe Radar in Richtung des Gegner
  		setTurnRight(bearing);// Fahre in Anhaegigkeit von der Linie Deines Gegners
 
  		if(distance > 90) { // Bist du zu weit weg fahre naeher ran
   			setAhead(distance - 85);
  		}
  		
  		if (distance < 80) { // Bist du zu nah, fahre ein stueck zur�ck
   			setBack(15);
  		}
	}
	
	/*
	***************************************Hilfsmethoden************************************************
	*/
	
	// Berechne aus gegebenem Winkel einen Winkel der zwischen -180 Grad und 180 Grad ist.
	public double winkelBerechnung(double winkel) { 
		if(winkel>-180&&winkel<=180) return winkel;
		double hilfswinkel = winkel;
		while (hilfswinkel <= -180)
			hilfswinkel += 360;
		while (hilfswinkel > 180)
			hilfswinkel -= 360;
		return hilfswinkel;
		
	}
	
	//Methode zur Bestimmung des Zukuenftigen Standortes des Gegners
	public void vorzielen(ScannedRobotEvent e,double feuerstaerke){
		//Deine Koordinaten	
		double meinX=getX();
		double meinY=getY();
		//Winkel zu Feind in Radianten
		double richtung_zu_feind=e.getBearingRadians()+getHeadingRadians();
		//Berechnug des jetztigen Punkt des Feindes
		double feindX= meinX+e.getDistance()*Math.sin(richtung_zu_feind);
		double feindY= meinY+e.getDistance()*Math.cos(richtung_zu_feind);
		double ausrichtung_feind=e.getHeadingRadians();
		double v_feind=e.getVelocity();
		int zeit = 0;
		double naechstes_feindX=feindX;
		double naechstes_feindY=feindY;
		double spielFeldHoehe= getBattleFieldHeight();
		double spielFeldBreite= getBattleFieldWidth();
		//Solange die Distanz groesser als die Geschwindigkeit meines Projektils ist muss ich um einen weiteren Punkt vorhalten
		while((++zeit)*(20.0-3.0*feuerstaerke)<Point2D.Double.distance(meinX, meinY,naechstes_feindX, naechstes_feindY )){
			//Berechnung des zukuenftigen Punkt des Feindes
			naechstes_feindX+=v_feind*Math.sin(ausrichtung_feind);
			naechstes_feindY+=v_feind*Math.cos(ausrichtung_feind);
			if(naechstes_feindX< 18.0 || naechstes_feindY < 18.0 || naechstes_feindX > spielFeldHoehe-18.0|| naechstes_feindY > spielFeldBreite-18.0){
				naechstes_feindX = Math.min(Math.max(17.9,naechstes_feindX),spielFeldBreite-17.9);	
				naechstes_feindY = Math.min(Math.max(17.9,naechstes_feindY),spielFeldHoehe-17.9);
				break;
			}
						
		}
		double dx = naechstes_feindX - meinX;
		double dy = naechstes_feindY - meinY;
		double theta = Utils.normalAbsoluteAngle(Math.atan2(dx, dy));
		setTurnRadarRightRadians(Utils.normalRelativeAngle(richtung_zu_feind-getRadarHeadingRadians()));
		turnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		fire(feuerstaerke);				
	}
}
//Ende
