package ws2006.Team2;

/**
 * @author Thorsten Stadtfeld
 * @author Steffen Steinbrecher
 * @author Jzef Fehr
 * @author Stefan Reitz
 * 
 * created 2007-02-12 - 2007-02-16
 *  
 */

import java.awt.Color;
import robocode.*;

/**
* This robot is the leading bot of the team. It sends messages to the droid bot
* in order to tell him the position of the enemy. The both robot fire on the same target.
* If this robot dies it tell the droid to take his role an fight the enemies by its own.
*/
public class LeaderBot extends TeamRobot 
{
	
	private int count = 0;
	private int direction = 1;
	// Contains direction of turning the gun
	private double gunTurnAmt;
	// robot we're currently tracking
	private EnemyBot enemy;

	/**
	 * run : Main method of the TeamRobot object
	 * @param  
	 * @return
	 */	
	public void run() 
	{
		// Set tank colors
		setBodyColor(Color.black);
		setGunColor(Color.red);
		setRadarColor(Color.gray);
		setScanColor(Color.red);
		setBulletColor(Color.yellow);
		
		// create enemy object
		this.enemy = new EnemyBot();
		
		try {
				//sending enemy details to teammates
				broadcastMessage(this.enemy.getMessage());
			} 
		catch (Exception ex) { out.println("Message was not sent" + ex.getStackTrace());}
		// Keep the gun on position even while turning around
		setAdjustGunForRobotTurn(true);
		// Set run turn to 10 times
		gunTurnAmt = 10;
	
		// Loop all life
		while (true) 
		{
			// turn the gun checking for enemy
			turnGunRight(gunTurnAmt);
			count++;
			// turn left if no target has been found after 2 turns
			if (count > 2) gunTurnAmt = -10;
			// turn right if no target has been found after 5 turns
			if (count > 5) gunTurnAmt = 10;
	
			// look for another target if nothing has been found after 10 turns
			if (count > 11) 
			{
				this.enemy.reset();
				out.println("Resetting enemy");
							
				try {
					//sending enemy details to teammates
					broadcastMessage(this.enemy.getMessage());
				} catch (Exception ex) { out.println("Message was not sent" + ex.getStackTrace());}
			}
		}
	}

	
	/**
	 * onScannedRobotEvent : EventHandler of TeamRobot object.
	 * Will be called after finding a robot in the scanned range
	 * @param  ScannedRobotEvent
	 * @return
	 */
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		// check whether the scanned robot is a teammate then abort
		if (isTeammate(e.getName()))
			return;

		// if the stored enemy is the same as the scanned one then abort
		// Very important for tracking!!
		if (!this.enemy.none() && !e.getName().equals(this.enemy.getName()))
			return;
		
	
		// Otherwise -> the robot is an enemy
		// update enemy object
		enemy.update(e);
		// set the enemy's coorindinates for the teammates
		enemy.setCoordinates(this);
		try {
			broadcastMessage(this.enemy.getMessage());
		}
		catch (Exception ex) {out.println("Message was not sent" + ex.getStackTrace());}
		

		// reset counter
		count = 0;
		
		// if the target is far away the robot moves toward it
		if (this.enemy.getDistance() > 150) 
		{			
			gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
			setTurnGunRight(gunTurnAmt);
			setTurnRight(this.enemy.getBearing()); 
			setAhead(this.enemy.getDistance() - 140);
			execute();
			return;
		}
		
		// now the target is near
		gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
		setTurnGunRight(gunTurnAmt);
		execute();
		
		// get the fire power of the enemy and increase the own about that + 1 
		// fire 5 times non-stop
		int i = 1;
		if (this.enemy.getFirePower()!=0.0)
		{
			while(i<=5) {
				fire(this.enemy.getFirePower()+1);
				i++;
			}
		}
		else {
			while(i<=5) {
				fire(3);
				i++;	
			}
		}
		execute();
		
		
		// the target is to close, move backwards
		if (this.enemy.getDistance() < 100) {
			if (this.enemy.getBearing() > -90 && this.enemy.getBearing() <= 90) {
				setBack(40);
				execute();
			} else {
				setAhead(40);
				execute();
			}
		}
		// scan for enemy
		scan();
	}
	
	/**
	 * onRobotDeath : EventHandler of TeamRobot object.
	 * Will be called after another robot is dead. Method notifies other team robots
	 * not to fire on the old target, just to hesitate. 
	 * @param  RobotDeathEvent
	 * @return
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		// not the own teammate has died
		if (!e.getName().equals("teambots.DroidBot")) {
			//reset the enemy information
			this.enemy.reset();	
					
			try {
				// send stop action to the teammates
				broadcastMessage("stopAction");
			} catch (Exception ex)  {out.println("Message was not sent" + ex.getStackTrace());}
		}
	} 

	
	/**
	 * onDeath : EventHandler of TeamRobot object.
	 * Will be called after the robot itself dies. Notifies the teammates
	 * to continue attacking enemys by its own scan. 
	 * @param  DeathEvent
	 * @return
	 */
	public void onDeath(DeathEvent e) {
		try {
				broadcastMessage("LeaderBotDied_HoldOnKilling");
			} catch (Exception ex)  {out.println("Message was not sent" + ex.getStackTrace());}
		
	}
			
			
	/**
	 * doMovement : Method
	 * performs some action in order to move away from the scanning range of enemies
	 * @param  
	 * @return
	 */	
	public void doMovement() {
			fire(3);
			this.direction *=-1;
			setAhead(direction*200);		
			setTurnRightRadians(this.enemy.getBearing() - (Math.PI/2));
			execute();
			
	}
	
	
	/**
	 * onHitRobot : EventHandler of TeamRobot object.
	 * Called after the robot has been hit by another 
	 * @param  HitRobotEvent
	 * @return
	 */
	public void onHitRobot(HitRobotEvent e) {
		// Do action if it was no teammate
		if (!isTeammate(e.getName())) {
			// Set the target
			// set the hitting robot as new enemy 
			enemy.update(e);
			enemy.setCoordinates(this);
					
				try {
					broadcastMessage(this.enemy.getMessage());
				}
				catch (Exception ex) {out.println("Message was not sent" + ex.getStackTrace());}
			
			// Turn gun on enemy	
			gunTurnAmt = normalRelativeAngle(this.enemy.getBearing() + (getHeading() - getRadarHeading()));
			setTurnGunRight(gunTurnAmt);
			setFire(2);
			execute();
			setBack(50);
			execute();
		}
	}

	/**
	 * onHitByBullet : EventHandler of TeamRobot object.
	 * Called after the robot has been hit by a bullet. The move out the scanning range.
	 * @param  HitByBulletEvent
	 * @return
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		//move out of the scanning range
		doMovement();
	}

	

	/**
	 * normalAbsoluteAngle
	 * Calculates fixed angle from given angle
	 * @param  double > angle
	 * @return double > fixed angle
	 */
	public double normalAbsoluteAngle(double angle) {
		if (angle >= 0 && angle < 360) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle < 0) {
			fixedAngle += 360;
		}
		while (fixedAngle >= 360) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}

	/**
	 * normalRealativeAngle
	 * Calculates fixed angle from given angle
	 * @param  double > angle
	 * @return double > fixed angle
	 */	
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}


}
