package ws2006.Team1;

import robocode.*;
import java.awt.Color;

/**
 * Terminator - ein Roboter von Team 1 (Martin Hartig, Stefan Zeller, Michael Hock)
 */
public class Terminator extends TeamRobot {


    /**
     * Variablen
     */
    double gunTurnAmt; // Kanone drehen
    String trackName = null; // Gerade zu attackierender Feindname
    String lastName = null; // Zuvor attackierter Feind
    int radarScanCount = 0; //Wechsel zwischen fullRadarScanHunter() und quarterRadarScanHunter()
    boolean peek; // Nicht drehen falls ein Feind an dieser Stelle steht
    double moveAmount; // Wieviel soll sich der Panzer bewegen
    double power = 50; //Bei Unterschreitung der "power" wird ein Strategiewechsel vollzogen
    boolean runAway = false; //Wechsel zwischen Hunter- und Supporterstrategie

    /**
     * run: Terminator's Startmethode
     */
    public void run() {

        while (true) { //Endlosschleife

            if (!runAway && getEnergy() > power) { //Wenn runAway=false und die Energie > 50 ist, solange
                moveHunter(); //wird die Jgerstrategie gefahren
            } else { //Sobald runAway=true oder die Energie <= 50 ist
                runAway = true;
                try {
                    //Empfnger sendet dem Teamroboter eine Nachricht
                    sendMessage("t1.Scout", new Message("changeStrategy"));
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                moveSupporter(); //Wechsel auf die Verteidigungsstrategie
            }
        }
    }

    /**
     * Fortbewegung whrend der Verteidigungsstrategie
     */
    public void moveSupporter() {
        // Initialisiere Schlachtfeldgre
        moveAmount = Math.max(getBattleFieldWidth(), getBattleFieldHeight());
        // Initialisiere peek=false
        peek = false;

        // Zur Wand drehen und an der Wand entlang fahren
        turnLeft(getHeading() % 90);
        ahead(moveAmount);

        // Kanone um 90 nach rechts drehen
        peek = true;
        turnGunRight(90);
        turnRight(90);

        while (true) {
            //Scanne und berprfe ob ein Gegener im Weg steht
            peek = true;
            // An der Wand entlang fahren
            ahead(moveAmount);
            // Nicht mehr scannen
            peek = false;
            // Zur nchsten Wand drehen
            turnRight(90);
        }
    }


    /**
     * Fortbewegung whrend der Jgerstrategie
     */
    public void moveHunter() {

	fullRadarScanHunter(); //kompletter Scan
        while (getEnergy() > power) { //Energie > 50

            if (radarScanCount < 2) { //Zwei mal scannen
                quarterRadarScanHunter(); //Schnellerer Scan
                radarScanCount++; //erhhe radarScanCount

            } else { //Nach zwei Scans
                fullRadarScanHunter(); //kompletter Scan
                radarScanCount = 0; //Setze radarScanCount auf 0
            }
        }
        return;
    }

    /**
     * Sucht einen Feind nach dem Scan aus und schickt den Feindname an den Teamroboter weiter
     * @param e ScannedRobotEvent
     */

    public void getTrackNameHunter(ScannedRobotEvent e) {

        if (trackName == null) { // Wenn kein Feind ausgewhlt, dann suche einen
            if (lastName == null || !lastName.equals(e.getName())) {
                trackName = e.getName();
                lastName = trackName;
                try {
                    //bermittelt dem Teamroboter den ausgewhlten Feind ber eine Nachricht
                    sendMessage("t1.Scout", new Message(trackName));
                } catch (Exception ex) {}
            }
        }

    }

    /**
     * Diese Methode ortet den Feind whrend der Jgerstrategie
     * @param e ScannedRobotEvent
     */
    public void enemyAttackHunter(ScannedRobotEvent e) {
        getTrackNameHunter(e); //Name des Feindes auswhlen
        if (trackName != null && trackName.equals(e.getName())) { //Wenn ein Feind existiert und dieser unserem ausgewhlten Feind entspricht
            double enemyBearing = this.getHeading() + e.getBearing(); //Richtung zum georteten Panzer
            double enemyX = getX() +
                            e.getDistance() *
                            Math.sin(Math.toRadians(enemyBearing)); //Ermittelt X-Koordinate des Feindes
            double enemyY = getY() +
                            e.getDistance() *
                            Math.cos(Math.toRadians(enemyBearing)); //Ermittelt Y-Koordinate des Feindes
            double ourX = getX(); //Ermittelt die eigene X-Koordinate
            double ourY = getY(); //Ermittelt die eigene Y-Koordinate
            double dx = enemyX - ourX; //Differenz zwischen eigener und Feindposition X
            double dy = enemyY - ourY; //Differenz zwischen eigener und Feindposition Y
            double theta = Math.toDegrees(Math.atan2(dx, dy)); //Winkelberechnung
            double angle = normalRelativeAngle(theta - getGunHeading()); //Relativer Winkel zum Feind

            fire(3);
            radarScanCount = 0; //Wieder fullRadarScanHunter() mglich

        }
    }

    /**
     * Suche Feind nach Scan aus und fahre zu ihm hin
     * @param e ScannedRobotEvent
     */
    public void selectEnemyHunter(ScannedRobotEvent e) {
        getTrackNameHunter(e); //Name des Feindes auswhlen

        if (trackName!=null&&trackName.equals(e.getName())) { //Entspricht der ausgewhlte feindliche Roboter dem gescannten
            if (e.getDistance() > 150) { // 150 < Distanz
                //Richtung zum Feind ermitteln
                gunTurnAmt = normalRelativeAngle(e.getBearing() +
                                                 (getHeading() -
                                                  getRadarHeading()));

                turnRight(e.getBearing()); //Zum Feind drehen
                ahead(e.getDistance() - 100); //Fahre bis auf 50 Pixel an den Feind heran
                return;
            }
            if (e.getDistance() > 50) { // 50 < Distanz <= 150
                //Richtung zum Feind ermitteln
                gunTurnAmt = normalRelativeAngle(e.getBearing() +
                                                 (getHeading() -
                                                  getRadarHeading()));
                //Zum Feind drehen
                turnRight(e.getBearing());
                fire(1);
                return;
            }

            if (e.getDistance() < 50) { //Distanz < 50
                //Richtung zum Feind ermitteln
                gunTurnAmt = normalRelativeAngle(e.getBearing() +
                                                 (getHeading() -
                                                  getRadarHeading()));
                //Zum Feind drehen
                turnRight(e.getBearing());
                back(e.getDistance() + 50); //Um Distanz + 50 zurckfahren
                return;
            }
        }

    }

    /**
     * Kompletter Radarscan um 360
     */
    public void fullRadarScanHunter() {
        turnRadarRight(360);

    }

    /**
     * Wechselseitiger Radarscan um 45 nach rechts und 45 nach links
     */
    public void quarterRadarScanHunter() {

        turnRadarRight(45);
        turnRadarLeft(45);

    }


    /**
     * Event wenn ein Roboter stribt
     * @param e RobotDeathEvent
     */
    public void onRobotDeath(RobotDeathEvent e) {
	try{
        if (trackName.equals(e.getName())) { //Wenn ausgewhlter Feind zerstrt wurde
            trackName = null; //trackName fr neuen Feind freigeben
        }
	}catch(Exception ex){};

    }


    /**
     * Allgemeine ScanEvent-Methode
     * @param e ScannedRobotEvent
     */
    public void onScannedRobot(ScannedRobotEvent e) {
        if (isTeammate(e.getName())) { //berprfen ob es sich um einen Teamkollege handelt
            return;
        }
        if (!runAway && getEnergy() > power) { //Jgerstrategie und die Energie > 50

            enemyAttackHunter(e); //Suche Gegener und attackiere ihn
            selectEnemyHunter(e); //Fahre Gegener hinterher

        } else { //Verteidigungsstrategie wenn Energie < 50
            onScannedRobotSupporter(e);
        }
    }

    /**
     * Wird eine feindlicher Roboter in der Verteidigungsstrategie gescannt, soll geschossen werden
     * @param e ScannedRobotEvent
     */
    public void onScannedRobotSupporter(ScannedRobotEvent e) {
        fire(2);

        if (peek) { ////falls kein Feind an dieser Stelle steht
            scan(); //manueller Scan
        }
    }

    /**
     * Reagiert auf Kollisionen mit aneren Panzern
     * @param e HitRobotEvent
     */
    public void onHitRobot(HitRobotEvent e) {

        if (!runAway && getEnergy() > power) { //Jgerstrategie und die Energie > 50
            onHitRobotHunter(e); //Ausweichstrategie (Jger)
        } else { //Verteidigungsstrategie wenn Energie < 50
            onHitRobotSupporter(e); //Ausweichstrategie (Hunter)
        }

    }

    /**
     * Ausweichstrategie (Jger)
     * @param e HitRobotEvent
     */
    public void onHitRobotHunter(HitRobotEvent e) {
        fire(3); //Schiee volle Kraft
        back(30); //30 Pixel zurck
        turnLeft(20); //20 links drehen
        ahead(30); //30 Pixel vorwrts
        fullRadarScanHunter(); //Kompletter Radarscan
    }

    /**
     * Bei Kollision in der Verteidigungsstartegie
     * @param e HitRobotEvent
     */

    public void onHitRobotSupporter(HitRobotEvent e) {
        // Wenn Panzer vor uns, fahre ein Stck zurck
        if (e.getBearing() > -90 && e.getBearing() < 90) {
            back(100);
        } else { // falls er hinter uns steht, fahre ein Stck vorwrts
            ahead(100);
        }
    }

    /**
     * Winkelberechnung
     * @param angle double
     * @return double
     */
    public double normalRelativeAngle(double angle) {
        if (angle > -180 && angle <= 180) { //Wenn  -180 < Winkel <= 180
            return angle; //Gib Winkel zurck
        }
        double fixedAngle = angle; //sonst...

        while (fixedAngle <= -180) { //wenn fixedAngle <= -180
            fixedAngle += 360; //addiere 360 auf bergebenen Winkel
        } while (fixedAngle > 180) { //wenn fixedAngle > 180
            fixedAngle -= 360; //subtrahiere 360 auf bergebenen Winkel
        }
        return fixedAngle;
    }


}
